---
generated_at: 2026-01-27 12:30:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：17-Script Editor 画面設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `editor/js/Script.js` - Script Editorの実装ファイル（504行）
- E-02: `editor/js/commands/SetScriptValueCommand.js` - スクリプト値更新コマンド
- E-03: `editor/js/commands/SetMaterialValueCommand.js` - マテリアル値更新コマンド
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CodeMirrorのテーマはmonokai | E-01 (75行目) | ○ |
| C-02 | 行番号表示は有効（lineNumbers: true） | E-01 (66行目) | ○ |
| C-03 | 括弧マッチは有効（matchBrackets: true） | E-01 (67行目) | ○ |
| C-04 | タブサイズは4（tabSize: 4） | E-01 (69行目) | ○ |
| C-05 | 変更時のデバウンスは300ms | E-01 (81行目) | ○ |
| C-06 | JavaScriptの検証にesprima.parse()を使用 | E-01 (171行目) | ○ |
| C-07 | JSONの検証にjsonlint.parse()を使用 | E-01 (211行目) | ○ |
| C-08 | GLSLの検証はrenderer.info.programsを使用 | E-01 (229行目) | ○ |
| C-09 | JavaScript時はSetScriptValueCommandを実行 | E-01 (91行目) | ○ |
| C-10 | JSON時はSetMaterialValueCommandを実行 | E-01 (105, 112, 119行目) | ○ |
| C-11 | GLSLはマテリアルに直接設定 | E-01 (225-227行目) | ○ |
| C-12 | エラー行にerrorLineクラスを適用 | E-01 (277行目) | ○ |
| C-13 | エラーメッセージをLineWidgetで表示 | E-01 (279行目) | ○ |
| C-14 | Ctrl+Spaceでオートコンプリート | E-01 (299-302行目) | ○ |
| C-15 | Ctrl+Iで型情報表示 | E-01 (303-306行目) | ○ |
| C-16 | Ctrl+Oでドキュメント表示 | E-01 (307-310行目) | ○ |
| C-17 | Alt+.で定義にジャンプ | E-01 (311-314行目) | ○ |
| C-18 | editorClearedでパネルを非表示 | E-01 (357-361行目) | ○ |
| C-19 | scriptRemovedで該当スクリプト編集中なら非表示 | E-01 (459-467行目) | ○ |
| C-20 | 閉じるボタンでcontainer.setDisplay('none') | E-01 (42-46行目) | ○ |
| C-21 | 関連機能にShaderMaterialが含まれる | E-05 (74行目) | ○ |
| C-22 | 関連機能にRawShaderMaterialが含まれる | E-05 (75行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべての主張についてソースコードから根拠を確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に明確な根拠がある

## 6) レビュアーチェックリスト（最小）
- [x] CodeMirrorの設定値が正確か
- [x] 各モード（JavaScript/JSON/GLSL）の検証ロジックが正確か
- [x] コマンド実行処理が正確か
- [x] キーボードショートカットが正確か
- [x] シグナルハンドラの処理が正確か
